/*
    epple2
    Copyright (C) 2008 by Christopher A. Mosher <cmosher01@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY, without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
#include "filterluma.h"

/*
    Generated by the utility at http://www-users.cs.york.ac.uk/~fisher/mkfilter
    1st order low-pass Butterworth filter at 2079545 Hz with extra zero at 3579545 Hz
    (sample rate 14318182 Hz)
*/

#define GAIN   6.074790079e+00

FilterLuma::FilterLuma() {
    xv[0]=xv[1]=xv[2]=xv[3]=0;
    yv[0]=yv[1]=yv[2]=yv[3]=0;
}

FilterLuma::~FilterLuma() {
}

double FilterLuma::next(const double v) {
    xv[0] = xv[1]; xv[1] = xv[2]; xv[2] = xv[3];
    xv[3] = v / GAIN;
    yv[0] = yv[1]; yv[1] = yv[2]; yv[2] = yv[3];
    yv[3] =   (xv[0] + xv[3]) +   0.9999995612 * (xv[1] + xv[2])
        + (  0.3415411775 * yv[2]);
    return yv[3];
}
